/*
 * Decompiled with CFR 0.152.
 */
package technology.rocketjump.undermount.mapgen.generators;

import java.util.Random;
import technology.rocketjump.undermount.mapgen.model.HeightmapVertex;
import technology.rocketjump.undermount.mapgen.model.VertexGameMap;

public class MidpointDisplacement {
    public VertexGameMap doubleSize(VertexGameMap input) {
        int inputYCursor;
        int inputXCursor;
        VertexGameMap output = new VertexGameMap(input.getNumTilesWide() * 2, input.getNumTilesHigh() * 2);
        for (inputXCursor = 0; inputXCursor <= input.getNumTilesWide(); ++inputXCursor) {
            for (inputYCursor = 0; inputYCursor <= input.getNumTilesHigh(); ++inputYCursor) {
                output.set(inputXCursor * 2, inputYCursor * 2, input.get(inputXCursor, inputYCursor).getHeight());
            }
        }
        for (inputXCursor = 0; inputXCursor < input.getNumTilesWide(); ++inputXCursor) {
            for (inputYCursor = 0; inputYCursor < input.getNumTilesHigh(); ++inputYCursor) {
                output.setAverageOfSquare(inputXCursor * 2 + 1, inputYCursor * 2 + 1);
            }
        }
        for (inputXCursor = 0; inputXCursor < input.getNumTilesWide(); ++inputXCursor) {
            for (inputYCursor = 0; inputYCursor < input.getNumTilesHigh(); ++inputYCursor) {
                output.setAverageOfDiamond(inputXCursor * 2 + 1, inputYCursor * 2);
                output.setAverageOfDiamond(inputXCursor * 2, inputYCursor * 2 + 1);
            }
        }
        return output;
    }

    public void applyDiamondSquareToPredoubled(VertexGameMap output, float maxVariance, Random random) {
        HeightmapVertex vertex;
        int inputYCursor;
        int inputXCursor;
        for (inputXCursor = 0; inputXCursor < output.getNumTilesWide() / 2; ++inputXCursor) {
            for (inputYCursor = 0; inputYCursor < output.getNumTilesHigh() / 2; ++inputYCursor) {
                vertex = output.get(inputXCursor * 2 + 1, inputYCursor * 2 + 1);
                vertex.setHeight(MidpointDisplacement.vary(vertex.getHeight(), maxVariance, random));
            }
        }
        for (inputXCursor = 0; inputXCursor < output.getNumTilesWide() / 2; ++inputXCursor) {
            for (inputYCursor = 0; inputYCursor < output.getNumTilesHigh() / 2; ++inputYCursor) {
                output.setAverageOfDiamond(inputXCursor * 2 + 1, inputYCursor * 2);
                vertex = output.get(inputXCursor * 2 + 1, inputYCursor * 2);
                if (vertex != null) {
                    vertex.setHeight(MidpointDisplacement.vary(vertex.getHeight(), maxVariance, random));
                }
                output.setAverageOfDiamond(inputXCursor * 2, inputYCursor * 2 + 1);
                vertex = output.get(inputXCursor * 2, inputYCursor * 2 + 1);
                if (vertex == null) continue;
                vertex.setHeight(MidpointDisplacement.vary(vertex.getHeight(), maxVariance, random));
            }
        }
    }

    public static float vary(float input, float maxVariance, Random random) {
        float varianceAmount = random.nextFloat() * (2.0f * maxVariance) - maxVariance;
        return input + varianceAmount;
    }
}

